/**
 * Kostra programu pro praci s polem.
 * 2020, Ales Smrcka
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

/// @brief Datovy typ pro osobu.
typedef struct {
    unsigned year; 
    char *name;
} Person;
 
/// @brief Datovy typ pro pole osob.
typedef struct {
    unsigned len; 
    Person *data;
} PersonArray;
 

// Konstruktor. Nastavi data o osobe z parametru. Pokud se alokace nepovedla, vraci 0 (false) jinak 1 (true).
int person_ctor(Person *p, unsigned year, const char *name)
{
    p->year = year;
    p->name = malloc(strlen(name)+1);

    if (p->name == NULL)
        return false;
    
    strcpy(p->name, name);

    return true;
}
 
// Destruktor. Vycisti zaznam o osobe
void person_dtor(Person *p)
{
    // chyba! neni uvolnovana pamet pro jmeno
    p->year = 0;
    p->name = NULL;
}
 
// Presune data osoby src na dst
void person_move(Person *src, Person *dst)
{
    *dst = *src;
}
 
// Zkopiruje data o osobe ze src na dst
// Vraci NULL, pokud se nepovedlo
void *person_copy(Person *src, Person *dst)
{
    // chyba! Neni provadena kopie jmena
    // kopii lze provest zavolanim konstruktoru osoby
    *dst = *src;
}
 
// Zameni data dvou zaznamu
void person_swap(Person *a, Person *b)
{
    Person tmp = *a;
    *a = *b;
    *b = tmp;
}
 
// Porovna dve osoby. Vraci <0, >0, 0, pokud a<b, a>b, a=b.
int person_cmp(Person *a, Person *b)
{
    if (a->year < b->year)
        return -1;
    if (a->year > b->year)
        return +1;
    return strcmp(a->name, b->name);
}
 
// Konstruktor pole.
void array_ctor(PersonArray *a)
{
    a->len = 0;
    a->data = NULL;
}
 
// 
void array_dtor(PersonArray *a)
{
    if (a->len > 0)
        free(a->data);
    // chyba! Je potreba zlikvidovat postupne vsechny zaznamy.
}
 
// Zvetsi velikost pole o 1 (increment).
// Vraci NULL, pokud se nepovedlo.
void *array_inc(PersonArray *a)
{
    void *p = realloc(a->data, (a->len+1)*sizeof(Person));
    if (p == NULL)
        return NULL;
    a->len++;
    return a->data = p;
}
 
// Vlozi zaznam o osobe na posledni pozici v poli, ktere bude rozsireno.
// Zaznam o osobe je zkopirovan.
void *array_append(PersonArray *a, Person *p)
{
    if (array_inc(a))
        return person_copy(p, &a->data[a->len-1]);
    else
        return NULL;
}
 
// Odstrani z pole prvek na indexu idx.
void array_remove(PersonArray *a, unsigned int idx)
{
    for (unsigned i = idx+1; i < a->len; i++)
        person_move(&a->data[i-1], &a->data[i]);
    if (a->len)
        a->data = realloc(a->data, (a->len-1)*sizeof(Person));
}
 
// Najde v poli osobu, ktera ma nejmensi year (a pripadne prvni v abecede)
// Minimum hleda od indexu idx. Pro hledani v celem poli treba zadat index 0.
// Vyuzijte funkci person_cmp
unsigned int array_find_min(PersonArray *a, int idx)
{
    // TODO
}
 
// Seradi osoby v poli podle jejich roku (a pripadne jmena)
void array_sort(PersonArray *a)
{
    // TODO
    
}

/// @brief  Binarni vyhledavani prvku v serazenem poli.
/// @param a Pole osob
/// @param p Hledana osoba
/// @return index v poli, na kterem se nachazi hledana osoba
unsigned int array_find_bin(PersonArray *a, Person *p)
{
    // TODO    
}

 
void array_print(PersonArray *a)
{
    for (unsigned i = 0; i < a->len; i++)
    {
        if (i)
            printf(", ");
        printf("[%d, %s]", a->data[i].year, a->data[i].name);
    }
    putchar('\n');
}
 
int main()
{
    PersonArray a;
    array_ctor(&a);
 
    // Vytvorime nekolik osob
    Person p1;
    bool b1 = person_ctor(&p1, 2000, "Bill");
    Person p2;
    bool b2 = person_ctor(&p2, 2010, "Amanda");
    Person p3;
    bool b3 = person_ctor(&p3, 1990, "Joe");
 
    if (!b1 || !b2 || !b3)
        return 1;

    // Osoby postupne NAKOPIRUJEME do pole (na konec, append)
    array_append(&a, &p1);
    array_append(&a, &p2);
    array_append(&a, &p3);
    // jeste vytvorime ctvrtou osobu, oproti 1. se bude lisit rokem.
    p1.year = 1990;
    array_append(&a, &p1);
 
    // [2000, Bill], [2010, Amanda], [1990, Joe], [1990, Bill]
    array_print(&a);
 
    // Najdeme prvni prvek
    unsigned int idx = array_find_min(&a, 0);
    printf("Minimalni prvek v poli je na indexu: %u\n", idx);
 
    // Seradime
    array_sort(&a);
 
    // [1990, Bill], [1990, Joe], [2000, Bill], [2010, Amanda]
    array_print(&a);

    // binarni vyhledavani v serazenem poli
    idx = array_find_bin(&a, &p2); // [2010, Amanda]
    printf("Osoba je na indexu: %u\n", idx); // index 3

    // Odstranime docasne vytvorene zaznamy o osobach
    // Vsechny osoby by mely mit zaznam v poli
    person_dtor(&p1);
    person_dtor(&p2);
    person_dtor(&p3);

    array_dtor(&a);
    return 0;
}
